package com.amity.socialcloud.sdk.core.data.file

import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class FileLocalDataStore {

    fun saveFiles(files: List<EkoFileEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().fileDao().save(files) }
    }

    fun createLocalFile(fileId: String, fileType: String, filePath: String) : Completable {
        return Completable.fromCallable {
            val fileDao = UserDatabase.get().fileDao()
            val fileEntity = EkoFileEntity().apply {
                this.fileId = fileId
                this.type = fileType
                this.filePath = filePath
            }
            fileDao.insert(fileEntity)
        }.subscribeOn(Schedulers.io())
    }

}