package com.amity.socialcloud.sdk.core.data.file

import android.net.Uri
import co.amity.rxupload.RxUploadService
import com.amity.socialcloud.sdk.core.AmityFile
import com.amity.socialcloud.sdk.core.AmityVideo
import com.amity.socialcloud.sdk.core.file.*
import com.ekoapp.core.utils.toV3
import com.ekoapp.ekosdk.AmityContentFeedType
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.mapper.AmityFilePropertiesMapper
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers


internal class FileRepository {

    fun getImage(fileId: String): AmityImage? {
        var file: AmityImage? = null
        Completable.fromCallable {
            val fileDao = UserDatabase.get().fileDao()
            val entity = fileDao.getByIdNow(fileId)
            val fileProps = AmityFilePropertiesMapper().map(entity)
            if (fileProps != null) {
               file = AmityImage(fileId, entity!!.filePath, fileProps)
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return file
    }

    fun getFile(fileId: String): AmityFile? {
        var file: AmityFile? = null
        Completable.fromCallable {
            val fileDao = UserDatabase.get().fileDao()
            val entity = fileDao.getByIdNow(fileId)
            val fileProps = AmityFilePropertiesMapper().map(entity)
            if (fileProps != null) {
                file = AmityFile(fileId, entity!!.filePath, fileProps)
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return file
    }

    fun getAudio(fileId: String): AmityAudio? {
        var file: AmityAudio? = null
        Completable.fromCallable {
            val fileDao = UserDatabase.get().fileDao()
            val entity = fileDao.getByIdNow(fileId)
            val fileProps = AmityFilePropertiesMapper().map(entity)
            if (fileProps != null) {
                file = AmityAudio(fileId, entity!!.filePath, fileProps)
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return file
    }

    fun getVideo(fileId: String): AmityVideo? {
        var file: AmityVideo? = null
        Completable.fromCallable {
            val fileDao = UserDatabase.get().fileDao()
            val entity = fileDao.getByIdNow(fileId)
            val fileProps = AmityFilePropertiesMapper().map(entity)
            if (fileProps != null) {
                file = AmityVideo(fileId, entity!!.filePath, fileProps)
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return file
    }

    fun uploadImage(uploadId: String, uri: Uri): Flowable<AmityUploadResult<AmityImage>> {
        return AmityImageUploadService.Builder()
            .fileUri(uri)
            .isFullImage(true)
            .uploadId(uploadId)
            .build()
            .transfer()
            .toV3()
    }

    fun uploadFile(uploadId: String, uri: Uri): Flowable<AmityUploadResult<AmityFile>> {
        return AmityFileUploadService.Builder()
            .fileUri(uri)
            .uploadId(uploadId)
            .build()
            .transfer()
            .toV3()
    }

    fun uploadAudio(uploadId: String, uri: Uri): Flowable<AmityUploadResult<AmityAudio>> {
        return AmityAudioUploadService.Builder()
            .fileUri(uri)
            .uploadId(uploadId)
            .build()
            .transfer()
            .toV3()
    }

    fun uploadVideo(uploadId: String, uri: Uri, feedType: AmityContentFeedType): Flowable<AmityUploadResult<AmityVideo>> {
        return AmityVideoUploadService.Builder()
            .fileUri(uri)
            .feedType(feedType)
            .uploadId(uploadId)
            .build()
            .transfer()
            .toV3()
    }

    fun cancelUpload(uploadId: String) {
        RxUploadService.cancel(uploadId)
    }

    fun getUploadInfo(uploadId: String): Flowable<AmityUploadInfo> {
        return RxUploadService.properties(uploadId)
            .map { AmityUploadInfo(it) }
    }

}