package com.amity.socialcloud.sdk.core.data.flag

import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class FlagRepository {

    fun isPostFlaggedByMe(postId: String): Boolean {
        var isFlaggedByMe = false
        Completable.fromCallable {
            val postFlagDao = UserDatabase.get().postFlagDao()
            val entity = postFlagDao.getByIdNow(postId)
            if (entity != null) {
                isFlaggedByMe = entity.isFlaggedByMe
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return isFlaggedByMe
    }

    fun isCommentFlaggedByMe(commentId: String): Boolean {
        var isFlaggedByMe = false
        Completable.fromCallable {
            val commentFlagDao = UserDatabase.get().commentFlagDao()
            val entity = commentFlagDao.getByIdNow(commentId)
            if (entity != null) {
                isFlaggedByMe = entity.isFlaggedByMe
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return isFlaggedByMe
    }

    fun isUserFlaggedByMe(userId: String): Boolean {
        var isFlaggedByMe = false
        Completable.fromCallable {
            val userFlagDao = UserDatabase.get().userFlagDao()
            val entity = userFlagDao.getByIdNow(userId)
            if (entity != null) {
                isFlaggedByMe = entity.isFlaggedByMe
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return isFlaggedByMe
    }

    fun isMessageFlaggedByMe(messageId: String): Boolean {
        var isFlaggedByMe = false
        Completable.fromCallable {
            val messageFlagDao = UserDatabase.get().messageFlagDao()
            val entity = messageFlagDao.getByIdNow(messageId)
            if (entity != null) {
                isFlaggedByMe = entity.isFlaggedByMe
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return isFlaggedByMe
    }

}