package com.amity.socialcloud.sdk.core.data.notification.community

import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.EkoPushNotificationEventDto
import com.ekoapp.ekosdk.internal.api.socket.request.NotificationSaveSettingsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class CommunityNotificationRemoteDataStore {

    fun getSetting(communityId: String): Single<EkoPushNotificationEventDto> {
        return EkoApi.get(CommunityNotificationApi::class)
            .flatMap {
                it.getSetting(communityId = communityId)
            }

    }

    fun saveSetting(request: NotificationSaveSettingsRequest.Community): Single<JsonObject> {
        return EkoApi.get(CommunityNotificationApi::class)
            .flatMap {
                it.saveSetting(request)
            }
    }

}