package com.amity.socialcloud.sdk.core.data.notification.device

import com.ekoapp.core.utils.toV3
import com.ekoapp.ekosdk.internal.data.EkoDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig
import io.reactivex.Maybe
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class DeviceNotificationLocalDataStore {

    fun register(): Completable {
        return EkoDatabase.get()
            .accountDao()
            .currentAccountSingle
            .flatMapCompletable { acc: EkoAccount ->
                io.reactivex.Completable.fromAction {
                    EkoDatabase.get()
                        .pushConfigDao()
                        .insert(EkoPushConfig(acc.userId, acc.deviceId, EkoPushConfig.State.REGISTERED))
                }
            }.toV3()
            .subscribeOn(Schedulers.io())
    }

    fun unregisterAll(): Completable {
        return Completable.fromAction {
            EkoDatabase.get()
                .pushConfigDao()
                .unregisterAll()
        }
            .subscribeOn(Schedulers.io())
    }

    fun unregister(userId: String): Completable {
        return EkoDatabase.get()
            .accountDao()
            .getByIdMaybe(userId)
            .switchIfEmpty(Maybe.never())
            .flatMapCompletable { acc: EkoAccount ->
                io.reactivex.Completable.fromAction {
                    EkoDatabase.get()
                        .pushConfigDao()
                        .insert(EkoPushConfig(acc.userId, acc.deviceId, EkoPushConfig.State.UNREGISTERED))
                }
            }.toV3()
            .subscribeOn(Schedulers.io())
    }

}