package com.amity.socialcloud.sdk.core.data.notification.user

import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.EkoPushNotificationModuleDto
import com.ekoapp.ekosdk.internal.api.socket.request.NotificationSaveSettingsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class UserNotificationRemoteDataStore {

    fun getSetting(): Single<EkoPushNotificationModuleDto> {
        return EkoApi.get(UserNotificationApi::class)
            .flatMap {
                it.getSetting()
            }
    }

    fun saveSetting(request: NotificationSaveSettingsRequest.User): Single<JsonObject> {
        return EkoApi.get(UserNotificationApi::class)
            .flatMap {
                it.saveSetting(request)
            }
    }

}