package com.amity.socialcloud.sdk.core.data.notification.user;

import com.amity.socialcloud.sdk.core.user.AmityUserNotificationModule
import com.amity.socialcloud.sdk.core.user.AmityUserNotificationSettings
import com.ekoapp.ekosdk.internal.api.mapper.EkoNotificationModuleRequestMapper
import com.ekoapp.ekosdk.internal.api.socket.request.NotificationSaveSettingsRequest
import com.ekoapp.ekosdk.internal.mapper.EkoPushNotificationMapper
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class UserNotificationRepository {

    fun saveNotificationSettings(
        isEnabled: Boolean,
        moduleModifiers: List<AmityUserNotificationModule.MODIFIER>? = null
    ): Completable {
        val request = NotificationSaveSettingsRequest.User(
            isEnabled,
            EkoNotificationModuleRequestMapper().map(moduleModifiers)
        )
        return UserNotificationRemoteDataStore().saveSetting(request)
            .ignoreElement()
    }

    fun getNotificationSettings(): Single<AmityUserNotificationSettings> {
        return UserNotificationRemoteDataStore().getSetting()
            .map {
                EkoPushNotificationMapper().mapToUserNotificationSettings(it)
            }
    }
}