package com.amity.socialcloud.sdk.core.data.reaction

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.core.reaction.AmityReaction
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity

class ReactionModelMapper : ModelMapper<EkoReactionEntity, AmityReaction>() {

    override fun map(entity: EkoReactionEntity): AmityReaction {
        return entity.run {
            AmityReaction(
                reactionId = reactionId,
                referenceType = referenceType,
                referenceId = referenceId,
                reactionName = reactionName,
                userId = userId,
                userDisplayName = userDisplayName ?: "",
                createdAt = createdAt
            )
        }
    }
}