package com.amity.socialcloud.sdk.core.data.reaction

import com.amity.socialcloud.sdk.common.LegacyQueryPersister
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto
import io.reactivex.Completable

internal class ReactionQueryPersister(
    val referenceType: ReactionReferenceType,
    val referenceId: String
) : LegacyQueryPersister<EkoReactionAndUserListDto>() {

    override fun persist(dto: EkoReactionAndUserListDto): Completable {
        return UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users))
            .andThen(
                ReactionLocalDataStore().saveReactions(
                    ReactionEntityMapper().map(dto)
                )
            ).toV2()
    }
}