package com.amity.socialcloud.sdk.core.data.reaction

import com.amity.socialcloud.sdk.core.data.reaction.dto.ReactionAddedDto
import com.amity.socialcloud.sdk.core.data.reaction.dto.ReactionRemovedDto
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto
import com.ekoapp.ekosdk.internal.api.socket.request.AddReactionRequest
import com.ekoapp.ekosdk.internal.api.socket.request.RemoveReactionRequest
import io.reactivex.rxjava3.core.Single

internal class ReactionRemoteDataStore {

    fun getReactions(
        referenceType: ReactionReferenceType,
        referenceId: String,
        reactionName: String? = null,
        limit: Int? = null,
        token: String? = null
    ): Single<EkoReactionAndUserListDto> {
        var actualReactionName = reactionName
        if (reactionName?.isEmpty() == true) {
            actualReactionName = null
        }
        return EkoApi.get(ReactionApi::class)
            .flatMap {
                it.queryReactions(
                    referenceType = referenceType.value,
                    referenceId = referenceId,
                    reactionName = actualReactionName,
                    limit = limit,
                    token = token
                )
            }
    }

    fun addReaction(
        referenceType: ReactionReferenceType,
        referenceId: String,
        reactionName: String
    ): Single<ReactionAddedDto> {
        return EkoApi.get(ReactionApi::class)
            .flatMap {
                it.addReaction(
                    AddReactionRequest(
                        referenceType = referenceType.value,
                        referenceId = referenceId,
                        reactionName = reactionName
                    )
                )
            }
    }

    fun removeReaction(
        referenceType: ReactionReferenceType,
        referenceId: String,
        reactionName: String
    ): Single<ReactionRemovedDto> {
        return EkoApi.get(ReactionApi::class)
            .flatMap {
                it.removeReaction(
                    RemoveReactionRequest(
                        referenceType = referenceType.value,
                        referenceId = referenceId,
                        reactionName = reactionName
                    )
                )
            }
    }

}