package com.amity.socialcloud.sdk.core.data.session

import com.amity.socialcloud.sdk.core.data.settings.network.NetworkSettingsRepository
import com.ekoapp.core.utils.toV3
import com.ekoapp.ekosdk.internal.api.EkoSocket
import com.ekoapp.ekosdk.internal.api.socket.request.UserGetRequest
import com.ekoapp.ekosdk.internal.data.EkoDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import com.google.common.base.Strings
import io.reactivex.rxjava3.schedulers.Schedulers

object SessionObserver {

    fun init() {
        EkoDatabase.get()
            .accountDao()
            .currentAccountFlowable
            .filter { account: EkoAccount ->
                !Strings.isNullOrEmpty(account.accessToken)
            }
            .toV3()
            .doOnNext {
                dummySocketJumpStart(it.userId)
                fetchChatSettings()
            }
            .doOnError {
                //AmityLog.tag(TAG).e("Error upon mqtt initialization")
            }
            .subscribeOn(Schedulers.io())
            .subscribe()
    }

    @Deprecated("To be removed along with socket")
    private fun dummySocketJumpStart(userId: String) {
        EkoSocket.rpc(UserGetRequest(listOf(userId))).toV3()
            .subscribeOn(Schedulers.io())
            .doOnError {
                // do nothing
            }
            .subscribe()
    }

    private fun fetchChatSettings() {
        NetworkSettingsRepository().getChatSettings()
            .subscribeOn(Schedulers.io())
            .doOnError {
                // do nothing
            }
            .subscribe()
    }

}