package com.amity.socialcloud.sdk.core.data.session

import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceRequest
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class SessionRemoteDataStore {

    fun registerDevice(
        apiKey: String,
        userId: String,
        displayName: String?,
        deviceId: String,
        authToken: String?,
        isLegacyVersion: Boolean
    ): Single<RegisterDeviceDto> {
        return Single.fromCallable {
            RegisterDeviceRequest.create(userId, displayName, deviceId, authToken)
        }.flatMap { request ->
            if (isLegacyVersion) {
                EkoApi.get(SessionApi::class)
                    .flatMap {
                        it.registerDeviceLegacy(apiKey, request)
                    }

            } else {
                EkoApi.get(SessionApi::class)
                    .flatMap {
                        it.registerDevice(apiKey, request)
                    }
            }
        }
    }

    fun verifyAccessToken(apiKey: String): Completable {
        return EkoApi.get(SessionApi::class)
            .flatMapCompletable {
                it.verifyAccessToken(apiKey)
            }
    }

}