package com.amity.socialcloud.sdk.core.data.tombstone

import com.amity.socialcloud.sdk.core.error.AmityError
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.entity.TombstoneEntity
import io.reactivex.rxjava3.core.Completable
import org.joda.time.DateTime
import org.joda.time.Duration

class TombstoneRepository {

    fun getTombstone(objectId: String, tombstoneModelType: TombstoneModelType): TombstoneEntity? {
        return TombstoneLocalDataStore().getTombstone(
            objectId = objectId,
            tombstoneModelType = tombstoneModelType
        )
    }

    fun saveTombstone(
        objectId: String,
        tombstoneModelType: TombstoneModelType,
        amityError: AmityError
    ): Completable {
        val tombstoneEntity = TombstoneEntity()
        tombstoneEntity.objectId = objectId
        tombstoneEntity.updatedAt = DateTime.now()
        tombstoneEntity.modelType = tombstoneModelType.entityName
        tombstoneEntity.errorCode = amityError.code
        return TombstoneLocalDataStore().saveTombstone(tombstoneEntity)
    }
}