package com.amity.socialcloud.sdk.core.data.topic

import com.amity.socialcloud.sdk.core.events.AmityTopic
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient
import io.reactivex.Completable

internal class TopicRepository {

    fun subscribe(topic: AmityTopic) : Completable {
       return AmityMqttClient.subscribe(topic)
    }

    fun unsubscribe(topic: AmityTopic) : Completable {
        return AmityMqttClient.unsubscribe(topic)
    }

}