package com.amity.socialcloud.sdk.core.data.user

import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.core.error.AmityError
import com.amity.socialcloud.sdk.core.error.AmityException
import com.amity.socialcloud.sdk.core.user.AmityUserSortOption
import com.ekoapp.ekosdk.UserEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class UserLocalDataStore {

    fun saveUsers(users: List<UserEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().userDao().save(users) }
    }

    fun getUser(userId: String): UserEntity? {
        var user: UserEntity? = null
        Completable.fromCallable {
            val entity = UserDatabase.get().userDao().getByIdNow(userId)
            if (entity != null) {
                user = entity
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return user
    }

    fun observeUser(userId: String): Flowable<UserEntity> {
        return UserDatabase.get().userDao().observeUser(userId)
            .map {
                if (it.isEmpty()) {
                    throw AmityException.create(
                        message = "item not found",
                        cause = null,
                        error = AmityError.ITEM_NOT_FOUND
                    )
                } else {
                    return@map it[0]
                }
            }
    }

    fun getUserPagingSource(
        keyword: String?,
        sortBy: AmityUserSortOption
    ): PagingSource<Int, UserEntity> {
        return UserDatabase.get().userPagingDao().getUserPagingSource(
            keyword,
            sortBy
        )
    }
}