package com.amity.socialcloud.sdk.core.data.user

import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto
import com.ekoapp.ekosdk.internal.api.socket.request.UserUpdateRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class UserRemoteDataStore {

    fun updateUser(request: UserUpdateRequest): Single<EkoUserListDto> {
        return EkoApi.get(UserApi::class)
            .flatMap {
                it.updateUser(request)
            }
    }

    fun getUsers(
        keyword: String?,
        sortBy: String?,
        limit: Int?,
        token: String?
    ): Single<EkoUserListDto> {
        return EkoApi.get(UserApi::class)
            .flatMap {
                it.queryUsers(
                    keyword = keyword ?: "",
                    sortBy = sortBy,
                    limit = limit,
                    token = token
                )
            }
    }

    fun getUser(userId: String): Single<EkoUserListDto> {
        return EkoApi.get(UserApi::class)
            .flatMap {
                it.getUser(userId)
            }
    }

    fun flagUser(userId: String): Single<EkoUserListDto> {
        return EkoApi.get(UserApi::class)
            .flatMap {
                it.flagUser(userId)
            }
    }

    fun unflagUser(userId: String): Single<EkoUserListDto> {
        return EkoApi.get(UserApi::class)
            .flatMap {
                it.unflagUser(userId)
            }
    }

    fun isFlaggedByMe(userId: String): Single<JsonObject> {
        return EkoApi.get(UserApi::class)
            .flatMap {
                it.isFlaggedByMe(userId)
            }
    }
    
}

