package com.amity.socialcloud.sdk.core.data.user.paging

import com.amity.socialcloud.sdk.core.user.AmityUserSortOption
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator


internal class UserKeyCreator(
    private val keyword: String?,
    private val sortBy: AmityUserSortOption
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "keyword" to (keyword ?: ""),
            "sortBy" to sortBy
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(): String {
        return "user.userId is not null"
    }

}