package com.amity.socialcloud.sdk.core.domain.reaction

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.core.reaction.AmityReaction
import io.reactivex.rxjava3.core.Completable

internal class ReactionComposerUseCase : ComposerUseCase() {

    fun execute(reaction: AmityReaction) : AmityReaction {
        addUserDisplayName(reaction)
            .blockingAwait()
        return reaction
    }

    private fun addUserDisplayName(reaction: AmityReaction) : Completable {
        return Completable.fromAction {
            val user = UserGetUseCase().execute(reaction.getUserId())
            user?.let {
                reaction.userDisplayName = it.getDisplayName() ?: ""
            }
        }
    }

}