package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.core.events.comment.AmityCommentEvents
import com.amity.socialcloud.sdk.social.comment.AmityComment
import io.reactivex.Single

class CommentTopicGeneratorUseCase {

    fun execute(comment: AmityComment, events: AmityCommentEvents) : Single<String> {
        val topic = when (events) {
            AmityCommentEvents.COMMENT -> {
                comment.path
            }
        }
        return Single.just(topic)
    }

}