package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.core.events.community.AmityCommunityEvents
import com.amity.socialcloud.sdk.social.community.AmityCommunity
import io.reactivex.Single

class CommunityTopicGeneratorUseCase {

    fun execute(community: AmityCommunity, events: AmityCommunityEvents) : Single<String>  {
        val topic = when (events) {
            AmityCommunityEvents.COMMUNITY -> {
                community.path
            }
            AmityCommunityEvents.POSTS -> {
                community.path + "/post/+"
            }
            AmityCommunityEvents.COMMENTS -> {
                community.path + "/post/+/comment/+"
            }
            AmityCommunityEvents.POSTS_AND_COMMENTS -> {
                community.path + "/post/#"
            }
        }
        //AmityLog.tag("CommunityTopicGenUC").i( "generated topic: " + topic)
        return Single.just(topic)
    }

}