package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.AmityCoreClient
import com.amity.socialcloud.sdk.core.domain.user.UserObserveUseCase
import com.amity.socialcloud.sdk.core.events.relationship.AmityFollowEvents
import io.reactivex.rxjava3.core.Single

class FollowTopicGeneratorUseCase {

    fun execute(events: AmityFollowEvents): Single<String> {
        return UserObserveUseCase().execute(AmityCoreClient.getUserId())
            .firstOrError()
            .map {
                val userPath = it.path
                val networkId = userPath.substringBefore("/")
                val userMId = it.mid
                when (events) {
                    AmityFollowEvents.MY_FOLLOWERS -> {
                        "$networkId/membership/$userMId/+/+"
                    }
                    AmityFollowEvents.MY_FOLLOWINGS -> {
                        "$networkId/membership/+/$userMId/+"
                    }
                }
            }
    }

}