package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.core.events.post.AmityPostEvents
import com.amity.socialcloud.sdk.social.feed.AmityPost
import io.reactivex.Single

class PostTopicGeneratorUseCase {

    fun execute(post: AmityPost, events: AmityPostEvents) : Single<String> {
        val topic = when (events) {
            AmityPostEvents.POST -> {
                post.path
            }
            AmityPostEvents.COMMENTS -> {
                post.path + "/comment/+"
            }
        }
        return Single.just(topic)
    }

}