package com.amity.socialcloud.sdk.core.domain.user

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.core.user.AmityUser
import io.reactivex.rxjava3.core.Completable

internal class UserComposerUseCase : ComposerUseCase() {

    fun execute(user: AmityUser): AmityUser {
        addFlag(user)
        addAvatar(user)
        return user
    }

    private fun addFlag(user: AmityUser) {
        user.isFlaggedByMe = IsUserFlaggedByMeUseCase().execute(user.getUserId())

    }

    private fun addAvatar(user: AmityUser) {
        user.avatarFileId?.let {
            user.avatar = ImageGetUseCase().execute(it)
        }
    }

}