package com.amity.socialcloud.sdk.core.domain.user

import com.amity.socialcloud.sdk.core.user.AmityUser
import com.amity.socialcloud.sdk.core.data.user.UserRepository
import io.reactivex.rxjava3.core.Flowable

class UserObserveUseCase {

    fun execute(userId: String) : Flowable<AmityUser> {
        return UserRepository().observe(userId)
            .map {
                UserComposerUseCase().execute(it)
            }
    }

}