package com.amity.socialcloud.sdk.core.encryption

sealed class AmityDBEncryption(val authDBKey: ByteArray?, val userDBKey: ByteArray?) {

    object NONE : AmityDBEncryption(authDBKey = null, userDBKey = null)

    class AUTH(passphrase: ByteArray) : AmityDBEncryption(authDBKey = passphrase, userDBKey = null)

    class ALL(passphrase: ByteArray) : AmityDBEncryption(authDBKey = passphrase, userDBKey = passphrase)

}