package com.amity.socialcloud.sdk.core.events

import com.amity.socialcloud.sdk.core.domain.topic.TopicSubscriptionUseCase
import com.amity.socialcloud.sdk.core.domain.topic.TopicUnsubscriptionUseCase
import io.reactivex.Completable

class AmityTopicSubscription internal constructor(val topic: AmityTopic) {

    fun subscribeTopic() : Completable {
        return TopicSubscriptionUseCase().execute(topic)
    }

    fun unsubscribeTopic() : Completable {
        return TopicUnsubscriptionUseCase().execute(topic)
    }

}