package com.amity.socialcloud.sdk.core.mention

import android.os.Parcelable
import kotlinx.android.parcel.Parcelize

sealed class AmityMentionMetadata : Parcelable {
    @Parcelize
    class CHANNEL constructor(private val index: Int, private val length: Int) :
        AmityMentionMetadata() {
        internal var type = AmityMentionType.CHANNEL.apiKey

        fun getIndex(): Int {
            return index
        }

        fun getLength(): Int {
            return length
        }
    }

    @Parcelize
    class USER constructor(
        private val userId: String,
        private val index: Int,
        private val length: Int
    ) : AmityMentionMetadata() {
        internal var type = AmityMentionType.USER.apiKey

        fun getUserId(): String {
            return userId
        }

        fun getIndex(): Int {
            return index
        }

        fun getLength(): Int {
            return length
        }
    }
}
