package com.amity.socialcloud.sdk.core.mention

import com.google.gson.Gson
import com.google.gson.JsonObject

class AmityMentionMetadataGetter constructor(private val metadata: JsonObject) {

    fun getMentionedUsers(): List<AmityMentionMetadata.USER> {
        val mentionMetadata = metadata.getAsJsonArray("mentioned")
        return mentionMetadata?.let { jsonArray ->
            jsonArray.map { Gson().fromJson(it, AmityMentionMetadata.USER::class.java) }
                .filter { AmityMentionType.enumOf(it.type) == AmityMentionType.USER }
        } ?: kotlin.run { listOf() }
    }

    fun getMentionedChannels(): List<AmityMentionMetadata.CHANNEL> {
        val mentionMetadata = metadata.getAsJsonArray("mentioned")
        return mentionMetadata?.let { jsonArray ->
            jsonArray.map { Gson().fromJson(it, AmityMentionMetadata.CHANNEL::class.java) }
                .filter { AmityMentionType.enumOf(it.type) == AmityMentionType.CHANNEL }
        } ?: kotlin.run { listOf() }
    }
}
