package com.amity.socialcloud.sdk.core.mention

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.user.AmityUser
import kotlinx.android.parcel.Parcelize

sealed class AmityMentionee : Parcelable {

    @Parcelize
    object CHANNEL : AmityMentionee()

    @Parcelize
    class USER constructor(private val userId: String) : AmityMentionee() {
        internal var user: AmityUser? = null

        internal constructor(userId : String, user: AmityUser?) : this(userId) {
            this.user = user
        }

        fun getUserId(): String {
            return userId
        }

        fun getUser(): AmityUser? {
            return user
        }
    }
}