package com.amity.socialcloud.sdk.core.session

import com.amity.socialcloud.sdk.AmityCoreClient
import com.ekoapp.ekosdk.internal.data.model.EkoAccount

internal class TokenVerifier {

    companion object {
        fun checkExpiration(ekoAccount: EkoAccount): Result {
            val now = AmityCoreClient.getServerTime()
            return if (now.isAfter(ekoAccount.expiresAt)) {
                Result.EXPIRED
            } else if (now.isBefore(ekoAccount.expiresAt) && now.isAfter(ekoAccount.aboutToExpireAt)) {
                Result.ABOUT_TO_EXPIRE
            } else {
                Result.VALID
            }
        }
    }

    enum class Result {
        VALID,
        ABOUT_TO_EXPIRE,
        EXPIRED
    }
}