package com.amity.socialcloud.sdk.core.session.component

import com.amity.socialcloud.sdk.core.data.settings.network.NetworkSettingsRepository
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus
import com.amity.socialcloud.sdk.core.session.model.SessionState
import com.ekoapp.core.utils.toV3
import com.ekoapp.ekosdk.internal.api.EkoSocket
import com.ekoapp.ekosdk.internal.api.socket.request.UserGetRequest
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import io.reactivex.rxjava3.schedulers.Schedulers

class UserSettingSessionComponent(
    sessionLifeCycleEventBus: SessionLifeCycleEventBus,
    sessionStateEventBus: SessionStateEventBus
) :
    SessionComponent(
        sessionLifeCycleEventBus, sessionStateEventBus
    ) {
    override fun onSessionStateChange(sessionState: SessionState) {
        //nothing
    }

    override fun establish(account: EkoAccount) {
        fetchChatSettings()
    }

    override fun destroy() {
        //nothing
    }

    override fun handleTokenExpire() {
        //nothing
    }

    //copy from old SessionObserver class
    private fun fetchChatSettings() {
        NetworkSettingsRepository().getChatSettings().subscribeOn(Schedulers.io()).doOnError {
            // do nothing
        }.subscribe()
    }
}