package com.amity.socialcloud.sdk.core.session.eventbus

import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.processors.PublishProcessor
import io.reactivex.rxjava3.schedulers.Schedulers

open class BaseEventBus<T> {
	
	private val eventPublisher: PublishProcessor<T> = PublishProcessor.create()
	
	open fun observe(): Flowable<T> {
		return eventPublisher
				.onBackpressureBuffer()
				.subscribeOn(Schedulers.io())
	}
	
	open fun publish(event: T) {
		eventPublisher.onNext(event)
	}
	
}