package com.amity.socialcloud.sdk.core.session.transformer

import com.amity.socialcloud.sdk.core.session.model.SessionLifeCycle
import com.amity.socialcloud.sdk.core.session.model.SessionState

object SessionLifeCycleTransformer {

    fun transform(currentSessionState: SessionState): SessionLifeCycle? {
        when (currentSessionState) {
            is SessionState.TokenExpired -> {
                return SessionLifeCycle.HandleTokenExpire
            }
            is SessionState.Terminated -> {
                return SessionLifeCycle.Destroy
            }
            is SessionState.NotLoggedIn -> {
                return SessionLifeCycle.Destroy
            }
        }
        return null
    }
}