package com.amity.socialcloud.sdk.core.session.transformer

import com.amity.socialcloud.sdk.core.session.model.AppEvent
import com.amity.socialcloud.sdk.core.session.model.SessionState

object SessionStateTransformer {

    fun transform(currentSessionState: SessionState, appEvent: AppEvent): SessionState? {
        when (appEvent) {
            is AppEvent.AppLaunchWithUser -> {
                if (currentSessionState == SessionState.NotLoggedIn) {
                    return SessionState.Established
                }
            }

            is AppEvent.AppLaunchWithoutUser -> {
                return SessionState.NotLoggedIn
            }

            is AppEvent.LoggingIn -> {
                if (currentSessionState == SessionState.NotLoggedIn
                    || currentSessionState == SessionState.Established
                    || currentSessionState is SessionState.Terminated
                ) {
                    return SessionState.Establishing
                }
            }

            is AppEvent.LoginSuccess -> {
                if (currentSessionState == SessionState.Establishing) {
                    return SessionState.Established
                }
            }

            is AppEvent.LoginFail -> {
                if (currentSessionState == SessionState.Establishing) {
                    return SessionState.NotLoggedIn
                }
            }

            is AppEvent.ManualLogout -> {
                return SessionState.NotLoggedIn
            }

            is AppEvent.TokenRenewSuccess -> {
                if (currentSessionState == SessionState.TokenExpired) {
                    return SessionState.Established
                }
            }

            is AppEvent.TerminationCodeReceive -> {
                if (currentSessionState == SessionState.Established || currentSessionState == SessionState.TokenExpired) {
                    return SessionState.Terminated(appEvent.error)
                }
            }

            is AppEvent.TokenExpire -> {
                return SessionState.TokenExpired
            }
        }
        return null
    }
}