package com.amity.socialcloud.sdk.core.token

import com.amity.socialcloud.sdk.AmityEndpoint
import com.amity.socialcloud.sdk.core.data.auth.AmityUserToken
import com.amity.socialcloud.sdk.core.domain.token.CreateAmityTokenUseCase
import com.ekoapp.core.utils.toV2
import io.reactivex.Single

class AmityUserTokenManager(
    private val apiKey: String,
    private val endpoint: AmityEndpoint
) {

    @Deprecated(
        message = "use createUserToken instead",
        replaceWith = ReplaceWith(
            "createUserToken(" +
                    "        userId: String," +
                    "        displayName: String?," +
                    "        secureToken: String? )"
        ),
        level = DeprecationLevel.WARNING
    )
    fun createAuthToken(
        userId: String,
        displayName: String? = null,
        secureToken: String? = null
    ): Single<AmityUserToken> {
        return createUserToken(
            userId = userId,
            displayName = displayName,
            secureToken = secureToken
        )
    }

    fun createUserToken(
        userId: String,
        displayName: String? = null,
        secureToken: String? = null
    ): Single<AmityUserToken> {
        return CreateAmityTokenUseCase().execute(
            endpoint = endpoint,
            apiKey = apiKey,
            userId = userId,
            displayName = displayName,
            secureToken = secureToken
        ).toV2()
    }

    //future function
    private fun refreshToken() {}

    //future function
    private fun revokeToken() {}

}
