package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.social.data.comment.CommentEventPersister
import com.amity.socialcloud.sdk.social.data.comment.CommentLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto
import com.amity.socialcloud.sdk.log.AmityLog
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass

internal abstract class CommentEventListener: MqttEventListener<EkoCommentAndUserListDto>()  {

    override val type: KClass<EkoCommentAndUserListDto>
        get() = EkoCommentAndUserListDto::class

    override fun processEvent(dto: EkoCommentAndUserListDto) {
        CommentEventPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: EkoCommentAndUserListDto): Boolean {
        var shouldProcessEvent = false
        val commentId = dto.comments?.first()?.commentId
        commentId?.let {
            shouldProcessEvent = CommentLocalDataStore().hasInLocal(it)
        }
        return shouldProcessEvent
    }

}