package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.AmityCoreClient
import com.amity.socialcloud.sdk.core.user.AmityMembershipType
import com.ekoapp.ekosdk.internal.api.dto.CommunityListDto

internal class CommunityUserRemoved : CommunityEventListener() {

    override fun getEventName(): String {
        return "community.userRemoved"
    }

    override fun processEvent(dto: CommunityListDto) {
        val myMembership = dto.communityUsers?.find {
            it.userId == AmityCoreClient.getUserId()
        }
        val isMySelfRemoved = myMembership != null && (myMembership.communityMembership?.let { AmityMembershipType.NONE.apiKey == it } ?: true)
        if(isMySelfRemoved) {
            dto.communities?.first()?.isJoined = false
        }
        super.processEvent(dto)
    }
}