package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.social.data.post.PostLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import io.reactivex.rxjava3.schedulers.Schedulers

internal class PostDeleted : PostEventListener() {

    override fun getEventName(): String {
        return "post.deleted"
    }

    override fun processEvent(dto: EkoPostQueryDto) {
        dto.posts.forEach {
            PostLocalDataStore()
                .hardDelete(it.postId)
                .subscribeOn(Schedulers.io())
                .subscribe()
        }
    }
}