package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoUserListMapper
import com.amity.socialcloud.sdk.core.data.user.UserRepository
import kotlin.reflect.KClass

internal abstract class UserEventListener: MqttEventListener<EkoUserListDto>() {

    override val type: KClass<EkoUserListDto>
        get() = EkoUserListDto::class

    override fun processEvent(dto: EkoUserListDto) {
        EkoUserListMapper.MAPPER.map(dto)
    }

    override fun shouldProcessEvent(dto: EkoUserListDto): Boolean {
        var shouldProcessEvent = false
        val userId = dto.users?.first()?.userId
        userId?.let {
            shouldProcessEvent = UserRepository().hasInLocal(it)
        }
        return shouldProcessEvent
    }

}