package com.amity.socialcloud.sdk.social.data.category

import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityCategoryListDto
import io.reactivex.rxjava3.core.Single
import retrofit2.http.GET
import retrofit2.http.Query

interface CategoryApi {

    @GET("api/v3/community-categories")
    fun queryCategories(
        @Query("sortBy") sortBy: String? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null
    ): Single<EkoCommunityCategoryListDto>


}