package com.amity.socialcloud.sdk.social.data.category

import com.ekoapp.ekosdk.community.category.CommunityCategoryEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers


internal class CategoryLocalDataStore {

    fun saveCategories(categories: List<CommunityCategoryEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().communityCategoryDao().save(categories) }
    }

    fun getCategories(categoryIds: List<String>): List<CommunityCategoryEntity> {
        var categories = emptyList<CommunityCategoryEntity>()
        Completable.fromCallable {
            val categoryDao = UserDatabase.get().communityCategoryDao()
            val entities = categoryDao.getByIdsNow(categoryIds)
            if(entities.isNotEmpty()) {
                categories = entities
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return categories
    }

}