package com.amity.socialcloud.sdk.social.data.category

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategory
import com.ekoapp.ekosdk.community.category.CommunityCategoryEntity

internal class CategoryModelMapper : ModelMapper<CommunityCategoryEntity, AmityCommunityCategory>() {

    override fun map(entity: CommunityCategoryEntity): AmityCommunityCategory {
        return AmityCommunityCategory(
            categoryId = entity.categoryId,
            name = entity.name,
            avatarFileId = entity.avatarFileId,
            avatar = null,
            metadata = entity.metadata,
            isDeleted = entity.isDeleted,
            createdAt = entity.createdAt,
            updatedAt = entity.updatedAt
        )
    }

}