package com.amity.socialcloud.sdk.social.data.category

import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams
import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityCategoryListDto
import io.reactivex.rxjava3.core.Single

internal class CategoryRemoteDataStore {

    fun queryCategories(
        sortBy: String? = null,
        isDeleted: Boolean? = null,
        options: QueryOptionsRequestParams
    ): Single<EkoCommunityCategoryListDto> {
        return EkoApi.get(CategoryApi::class)
            .flatMap {
                it.queryCategories(
                    sortBy = sortBy,
                    isDeleted = isDeleted,
                    limit = options.limit,
                    token = options.token
                )
            }
    }

}
