package com.amity.socialcloud.sdk.social.data.comment

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.core.data.mention.LegacyMentioneeModelMapper
import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.ekoapp.ekosdk.internal.entity.CommentEntity

class CommentModelMapper : ModelMapper<CommentEntity, AmityComment>() {

    override fun map(entity: CommentEntity): AmityComment {
        return entity.run {
            AmityComment(
                commentId = commentId,
                referenceType = referenceType,
                referenceId = referenceId,
                userId = userId,
                parentId = parentId,
                rootId = rootId,
                dataType = dataType,
                data = getRawData(),
                metadata = metadata,
                childrenNumber = childrenNumber,
                latestReplies = emptyList(),
                flagCount = flagCount,
                myReactions = emptyList(),
                reactionCount = reactionCount,
                reactions = reactions,
                isDeleted = isDeleted,
                editedAt = editedAt,
                createdAt = createdAt,
                updatedAt = updatedAt,
                syncState = syncState,
                user = null,
                mentionees = LegacyMentioneeModelMapper().map(entity.mentionees),
                path = path
            )
        }
    }

}