package com.amity.socialcloud.sdk.social.data.comment

import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.socket.request.CommentQueryRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CommentUpdateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CreateCommentRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

class CommentRemoteDataStore {

    fun createComment(request: CreateCommentRequest): Single<EkoCommentAndUserListDto> {
        return EkoApi.get(CommentApi::class)
            .flatMap {
                it.createComment(request)
            }
    }

    fun updateComment(
        commentId: String,
        request: CommentUpdateRequest
    ): Single<EkoCommentAndUserListDto> {
        return EkoApi.get(CommentApi::class)
            .flatMap {
                it.updateComment(commentId, request)
            }
    }

    fun deleteComment(commentId: String, hardDelete: Boolean): Single<EkoDeletionDto> {
        return EkoApi.get(CommentApi::class)
            .flatMap {
                it.deleteComment(commentId, hardDelete)
            }
    }

    fun queryComments(request: CommentQueryRequest): Single<EkoCommentAndUserListDto> {
        return EkoApi.get(CommentApi::class)
            .flatMap {
                it.queryComments(
                    referenceId = request.referenceId,
                    referenceType = request.referenceType,
                    filterByParentId = request.filterByParentId,
                    parentId = request.parentId,
                    isDeleted = request.isDeleted,
                    sortBy = request.sortBy,
                    limit = request.options.limit,
                    skip = request.options.skip,
                    type = request.options.type,
                    token = request.options.token
                )
            }
    }

    fun flagComment(commentId: String): Single<EkoCommentAndUserListDto> {
        return EkoApi.get(CommentApi::class)
            .flatMap {
                it.flagComment(commentId)
            }
    }

    fun unflagComment(commentId: String): Single<EkoCommentAndUserListDto> {
        return EkoApi.get(CommentApi::class)
            .flatMap {
                it.unflagComment(commentId)
            }
    }

    fun isFlaggedByMe(commentId: String): Single<JsonObject> {
        return EkoApi.get(CommentApi::class)
            .flatMap {
                it.isFlaggedByMe(commentId)
            }
    }

    fun getComments(
        request: CommentQueryRequest,
    ): Single<EkoCommentAndUserListDto> {
        return EkoApi.get(CommentApi::class)
            .flatMap {
                it.queryComments(
                    referenceId = request.referenceId,
                    referenceType = request.referenceType,
                    filterByParentId = request.filterByParentId,
                    parentId = request.parentId,
                    isDeleted = request.isDeleted,
                    sortBy = request.sortBy,
                    limit = request.options.limit,
                    skip = request.options.skip,
                    first = request.options.first,
                    last = request.options.last,
                    type = request.options.type,
                    token = request.options.token
                )
            }
    }

}