package com.amity.socialcloud.sdk.social.data.comment.reaction

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity

internal class CommentReactionEntityMapper : EntityMapper<EkoCommentDto, EkoReactionEntity>() {

    override fun map(list: List<EkoCommentDto>): List<EkoReactionEntity> {
        val reactions = mutableListOf<EkoReactionEntity>()
         list.forEach {
             val reactionNames = it.myReactions?.map { reactionName ->
                 ReactionRepository().createMyReaction(
                     ReactionReferenceType.COMMENT,
                     it.commentId,
                     reactionName!!,
                 )
             }
             reactionNames?.let {
                 reactions.addAll(it)
             }
        }
        return reactions
    }

}