package com.amity.socialcloud.sdk.social.data.community

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.core.AmityTags
import com.ekoapp.ekosdk.EkoCategoryIds
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityMapper
import com.ekoapp.ekosdk.internal.entity.CommunityEntity

internal class CommunityEntityMapper : EntityMapper<EkoCommunityDto, CommunityEntity>() {

    override fun map(list: List<EkoCommunityDto>): List<CommunityEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: EkoCommunityDto) : CommunityEntity {
        return CommunityEntity().apply {
            communityId = dto.communityId ?: communityId
            channelId = dto.channelId
            userId = dto.userId
            displayName = dto.displayName
            description = dto.description
            avatarFileId = dto.avatarFileId
            isOfficial = dto.isOfficial
            isPublic = dto.isPublic
            onlyAdminCanPost = dto.onlyAdminCanPost
            tags = dto.tags ?: AmityTags()
            metadata = dto.metadata
            postsCount = dto.postsCount
            membersCount = dto.membersCount
            isDeleted = dto.isDeleted
            categoryIds = dto.categoryIds ?: EkoCategoryIds()
            needApprovalOnPostCreation = dto.needApprovalOnPostCreation
            editedAt = dto.editedAt
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
            path = dto.path ?: path
            isJoined = dto.isJoined ?: true
        }

    }
}