package com.amity.socialcloud.sdk.social.data.community

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.social.community.AmityCommunity
import com.ekoapp.core.utils.requiredNonNull
import com.ekoapp.ekosdk.internal.entity.CommunityEntity

internal class CommunityModelMapper : ModelMapper<CommunityEntity, AmityCommunity>() {

    override fun map(entity: CommunityEntity): AmityCommunity {
        return entity.run {
            AmityCommunity(
                communityId = communityId,
                channelId = channelId ?: "",
                userId = userId ?: "",
                displayName = displayName ?: "",
                description = description ?: "",
                avatarFileId = avatarFileId ?: "",
                isOfficial = isOfficial ?: false,
                isPublic = isPublic ?: false,
                onlyAdminCanPost = onlyAdminCanPost ?: false,
                tags = tags,
                metadata = metadata,
                postsCount = postsCount ?: 0,
                membersCount = membersCount ?: 0,
                isJoined = isJoined ?: false,
                isDeleted = isDeleted ?: false,
                categoryIds = categoryIds,
                categories = emptyList(),
                user = null,
                avatarImage = null,
                isPostReviewEnabled = needApprovalOnPostCreation ?: false,
                createdAt = createdAt,
                updatedAt = updatedAt,
                path = path
            )
        }
    }
}