package com.amity.socialcloud.sdk.social.data.community

import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams
import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.CommunityListQueryDto
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.socket.request.*
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class CommunityRemoteDataStore {

    fun createCommunity(
        displayName: String,
        description: String?,
        categoryIds: List<String>?,
        isPublic: Boolean?,
        metadata: JsonObject?,
        userIds: List<String>?,
        avatarFileId: String?,
        needApprovalOnPostCreation: Boolean?,
        onlyAdminCanPost: Boolean?
    ): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityApi::class)
            .flatMap {
                it.createCommunity(
                    CommunityCreateRequest(
                        displayName = displayName,
                        description = description,
                        categoryIds = categoryIds,
                        isPublic = isPublic,
                        metadata = metadata,
                        userIds = userIds,
                        avatarFileId = avatarFileId,
                        needApprovalOnPostCreation = needApprovalOnPostCreation,
                        onlyAdminCanPost = onlyAdminCanPost
                    )
                )
            }
    }

    fun updateCommunity(
        communityId: String,
        displayName: String?,
        description: String?,
        categoryIds: List<String>?,
        isPublic: Boolean?,
        metadata: JsonObject?,
        avatarFileId: String?,
        needApprovalOnPostCreation: Boolean?,
        onlyAdminCanPost: Boolean?
    ): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityApi::class)
            .flatMap {
                it.updateCommunity(
                    communityId,
                    CommunityUpdateRequest(
                        communityId = communityId,
                        displayName = displayName,
                        description = description,
                        categoryIds = categoryIds,
                        isPublic = isPublic,
                        metadata = metadata,
                        avatarFileId = avatarFileId,
                        needApprovalOnPostCreation = needApprovalOnPostCreation,
                        onlyAdminCanPost = onlyAdminCanPost
                    )
                )
            }
    }

    fun joinCommunity(communityId: String): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityApi::class)
            .flatMap {
                it.joinCommunity(communityId)
            }
    }

    fun leaveCommunity(communityId: String): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityApi::class)
            .flatMap {
                it.leaveCommunity(communityId)
            }
    }

    fun deleteCommunity(communityId: String): Single<EkoDeletionDto> {
        return EkoApi.get(CommunityApi::class)
            .flatMap {
                it.deleteCommunity(communityId)
            }
    }

    fun getCommunity(communityId: String): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityApi::class)
            .flatMap {
                it.getCommunity(communityId)
            }
    }

    fun getRecommendedCommunities(options: QueryOptionsRequestParams): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityApi::class)
            .flatMap {
                it.getRecommendedCommunities(
                    limit = options.limit,
                    token = options.token
                )
            }
    }

    fun getTrendingCommunities(options: QueryOptionsRequestParams): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityApi::class)
            .flatMap {
                it.getTrendingCommunities(
                    limit = options.limit,
                    token = options.token
                )
            }
    }

    fun queryCommunities(
        keyword: String? = null,
        categoryId: String? = null,
        filter: String? = null,
        sortBy: String? = null,
        isDeleted: Boolean? = null,
        options: QueryOptionsRequestParams
    ): Single<CommunityListQueryDto> {
        return EkoApi.get(CommunityApi::class)
            .flatMap {
                it.queryCommunities(
                    keyword = keyword,
                    categoryId = categoryId,
                    filter = filter,
                    sortBy = sortBy,
                    isDeleted = isDeleted,
                    limit = options.limit,
                    token = options.token
                )
            }
    }

}