package com.amity.socialcloud.sdk.social.data.community.membership

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityMembershipDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityMembershipMapper
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity

class CommunityMembershipEntityMapper : EntityMapper<EkoCommunityMembershipDto, CommunityMembershipEntity>() {

    override fun map(list: List<EkoCommunityMembershipDto>): List<CommunityMembershipEntity> {
        return list.map {
            map(it)
        }
    }

    private fun map(dto: EkoCommunityMembershipDto) : CommunityMembershipEntity {
        return CommunityMembershipEntity().apply {
                id = dto.getId()
                userId = dto.userId ?: userId
                communityId = dto.communityId ?: ""
                channelId = dto.channelId
                communityMembership = dto.communityMembership
                metadata = dto.metadata
                isBanned = dto.isBanned
                roles = dto.roles
                permissions = dto.permissions
                createdAt = dto.createdAt
                updatedAt = dto.updatedAt
        }
    }

}